% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfhtcID.R
\name{lfhtcID}
\alias{lfhtcID}
\title{Determines which edges in a latent digraph are LF-HTC-identifiable.}
\usage{
lfhtcID(graph)
}
\arguments{
\item{graph}{a \code{\link{LatentDigraph}} object representing
the latent-factor graph. All latent nodes in this graph should be
source nodes (i.e. have no parents).}
}
\value{
returns a list with 5 components:
\describe{
  \item{\code{solvedParents}}{a list whose ith element contains a vector
  containing the subsets of parents of node i for which the edge j->i could
  be shown to be generically identifiable.}
  \item{\code{unsolvedParents}}{as for \code{solvedParents} but for the
  unsolved parents.}
  \item{\code{identifier}}{a function that takes a (generic) covariance
  matrix corresponding to the graph and identifies the edges parameters
  from solvedParents and solvedSiblings. See \code{\link{htcIdentifyStep}}
  for a more in-depth discussion of identifier functions.}
  \item{\code{graph}}{a latent digraph object of the graph.}
  \item{\code{call}}{the call made to this function.}
  \item{\code{activeFroms}}{list. If node i is solved then the ith index
  is a vector containing the nodes Y otherwise it is empty.}
  \item{\code{Zs}}{list. If node i is solved then the ith index is a
  vector containing the nodes Z otherwise it is empty.}
  \item{\code{Ls}}{list. If node i is solved then the ith index is a
  vector containing the nodes L otherwise it is empty.}
}
}
\description{
Uses the latent-factor half-trek criterion to determine
which edges in a latent digraph are generically identifiable.
}
\references{
Barber, R. F., Drton, M., Sturma, N., and Weihs L. (2022).
Half-Trek Criterion for Identifiability of Latent Variable Models.
\emph{arXiv preprint} arXiv:2201.04457
}
