% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SOPC_estimation.R
\name{SOPC_estimation}
\alias{SOPC_estimation}
\title{SOPC Estimation Function}
\usage{
SOPC_estimation(data, gamma, eta)
}
\arguments{
\item{data}{Matrix of SFM data.}

\item{gamma}{Tuning parameter for the sparseness of the loadings matrix.}

\item{eta}{Tuning parameter for the sparseness of the common factors  matrix.}
}
\value{
A list containing:
\item{Aso}{Estimated factor loadings.}
\item{Dso}{Estimated common factors .}
\item{tauA}{Sparsity of the loadings matrix, calculated as the proportion of zeros.}
}
\description{
This function processes Skew Factor Model (SFM) data using the Sparse Online Principal Component (SOPC) method.
}
\examples{
set.seed(123) # For reproducibility
data <- matrix(runif(200), nrow = 20) # Skew Factor Model data
sopc_results <- SOPC_estimation(data, 0.1, 0.8)
print(sopc_results)

}
