% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHAP_funcs.R
\name{shap.plot.dependence.color}
\alias{shap.plot.dependence.color}
\title{SHAP dependence plot and interaction plot, colored by a selcted feature value}
\usage{
shap.plot.dependence.color(data_long, data_int = NULL, x, y,
  color_feature = NULL, smooth = T, size0 = NULL)
}
\arguments{
\item{data_long}{the long format SHAP values.}

\item{data_int}{the 3-dimention SHAP interaction values array.
from \code{predict.xgb.Booster} or \code{\link{shap.prep.interaction}}.}

\item{x}{which feature to show on x axis, it will plot the feature value.}

\item{y}{which shap values to show on y axis, it will plot the SHAP value.}

\item{color_feature}{which feature value to use for coloring, color by the feature value.}

\item{smooth}{optional to add loess smooth line, default to TRUE.}

\item{size0}{point size, default to 1 of nobs<1000, 0.4 if nobs>1000.}
}
\value{
returns a ggplot2 object, based on which you could add more geom layers.
}
\description{
This function makes the dependence plot by default.
Colored by the feature value of \code{y} if \code{color_feature} is not supplied.
You shall choose to plot SHAP values of \code{y} vs. feature values of \code{x}.
If \code{data_int} (the SHAP interaction values dataset) is supplied, it will plot
the interaction effect between \code{y} and \code{x} on the y axis.
}
\details{
Dependence plot is very easy to make if you have the SHAP values dataset from \code{predict.xgb.Booster}
It is not necessary to start with the long-format data, but since I used that
for the summary plot, I just continue to use the long dataset
}
\examples{
# **SHAP dependence plot**
shap.plot.dependence.color(data_long = shap_long_iris, x="Petal.Length",
                           y = "Petal.Width", color_feature = "Petal.Width")
# the without color version, just plot SHAP value against feature value:
shap.plot.dependence(data_long = shap_long_iris, "Petal.Length")

}
