\name{cshare}
\alias{cshare}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Stepwise search for the most informative haplotypes}
\description{
   The cshare function seeks the most informative set of SNPs for
   genetic association in a targeted region by growing/shrinking
   haplotypes with one more/less SNP in a stepwise fashion, and
   comparing prediction errors of different models via cross-validation
   or BIC.
}
\usage{
cshare(haploObj, status, nfold = 10, maxsnps, tol = 1e-08,
       verbose = FALSE, ModSelMethod = c("Cross-Val", "BIC"),
       Minherit = c("additive", "dominant", "recessive"))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{haploObj}{A object of calss "haplo". \code{haploObj} could be
    generated by the function \code{haplo}.}
  %%\item{phenoData}{A vector of phenotype values for the subjects in the
  %%  sample.}
  \item{status}{A character string indicating the column name of the phenotype in
    \code{haploObj@pheno} to be used as the clinical status in the analysis.}
  \item{nfold}{An integer that determines how many folds in the
    cross-validation, if ModSelMethod="Cross-Val"}
  \item{maxsnps}{An integer that determines the maximal number of SNPs
    to be chosen. The default is 6.}
  \item{tol}{The convergence parameters in haplotype logistic regression}
  \item{verbose}{TRUE/FALSE to decide whether to create log file for debug}
  \item{ModSelMethod}{Model selection method.  Possible methods are
    "Cross-Val" for cross-validation, and "BIC" for Bayesian information criterion}
  \item{Minherit}{Mode of inheritance.  Possible mode are "additive",
    "dominant", and "recessive"}
}
\details{
  This function takes input from a phased genotype dataset and
  case-control status, performs stepwise search for the most informative
  haplotypes based on deviance criterion, either by cross-validation or
  by BIC. The function output the prediction deviances of a ladder of models up
  to the size of "maxsnps" values and best haplotype model selected.
}
\value{
  \code{cshare} returns a object of class "share"
  %%which results in the
  %%following two slots:
  %%\item{deviance}{A vector containing the prediction of deviances from the random permutation
  %%for a ladder of models up to the size of "maxsnps" values.}
  %%\item{bestsize}{The number of SNPs which results in minimum deviances}
  %%For the information of other slots in the class "share", see the
  %%document of "share" class.
}
\references{
Dai, J. Y., LeBlanc, M., Smith, N. L., Psaty, B. M. and Kooperberg, C. (2009). SHARE: 
an adaptive algorithm to select the most informative set of SNPs for genetic associat ion. 
Biostatistics, In Press.
}
\author{James Y. Dai}
%%\note{ ~~further notes~~ 
%%
%% ~Make other sections like Warning with \section{Warning }{....} ~
%%}
\seealso{\code{\link{haplo}}, \code{\link{share-class}}}
\examples{
## See vignette for more details
\dontrun{
unphasedKerem <- list()
unphasedKerem[["Cross-Val"]] <- cshare(unphasedHaplo, status="CF",
                                       nfold=20, maxsnps=5,
                                       ModSelMethod="Cross-Val",
				       Minherit="additive")
unphasedKerem[["Cross-Val"]]

unphasedKerem[["BIC"]] <- cshare(unphasedHaplo, , status="CF",
                         maxsnps=5, ModSelMethod="BIC", Minherit="additive", verbose=1)
unphasedKerem[["BIC"]]
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
