% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covk.2001Schott.R
\name{covk.2001Schott}
\alias{covk.2001Schott}
\title{Test for Homogeneity of Covariances by Schott (2001)}
\usage{
covk.2001Schott(dlist)
}
\arguments{
\item{dlist}{a list of length \eqn{k} where each element is a sample matrix of same dimension.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value \eqn{P(H_0|H_1)} under current setting.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given univariate samples \eqn{X_1~,\ldots,~X_k}, it tests
\deqn{H_0 : \Sigma_1 = \cdots \Sigma_k\quad vs\quad H_1 : \textrm{at least one equality does not hold}}
using the procedure by Schott (2001) using Wald statistics. In the original paper, it provides 4 
different test statistics for general elliptical distribution cases. However, we only deliver 
the first one with an assumption of multivariate normal population.
}
\examples{
## CRAN-purpose small example
tinylist = list()
for (i in 1:3){ # consider 3-sample case
  tinylist[[i]] = matrix(rnorm(10*3),ncol=3)
}
covk.2001Schott(tinylist) # run the test

\donttest{
## test when k=5 samples with (n,p) = (100,20)
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  mylist = list()
  for (j in 1:5){
     mylist[[j]] = matrix(rnorm(100*20),ncol=20)
  }
  
  counter[i] = ifelse(covk.2001Schott(mylist)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\\n* Example for 'covk.2001Schott'\\n\\n",
sprintf("* number of rejections   : \%d\\n",sum(counter)),
sprintf("* total number of trials : \%d\\n",niter),
sprintf("* empirical Type 1 error : \%.4f\\n", sum(counter/niter)),sep=""))
}

}
\references{
\insertRef{schott_tests_2001}{SHT}
}
