% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getCasteId}
\alias{getCasteId}
\title{Get IDs of individuals of a caste, or ID of all members of colony}
\usage{
getCasteId(x, caste = "all", collapse = FALSE, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link{Pop-class}}, \code{\link{Colony-class}}, or
\code{\link{MultiColony-class}}}

\item{caste}{character, "queen", "fathers", "workers", "drones",
"virginQueens", or "all"}

\item{collapse}{logical, if all IDs should be returned as a single vector}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}
}
\value{
when \code{x} is \code{\link{Pop-class}} for \code{caste != "all"}
 or list for \code{caste == "all"} with ID nodes named by caste;
   when \code{x} is \code{\link{Colony-class}} return is a named list of
  \code{\link{Pop-class}} for \code{caste != "all"}
  or named list for \code{caste == "all"} indluding caste members IDs;
   when \code{x} is \code{\link{MultiColony-class}} return is a named list of
  \code{\link{Pop-class}} for \code{caste != "all"} or named list of lists of
  \code{\link{Pop-class}} for \code{caste == "all"} indluding caste members IDs
}
\description{
Level 0 function that returns the ID individuals of a caste. To
  get the individuals, use \code{\link{getCastePop}}. To get individuals'
  caste, use \code{\link{getCaste}}.
}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 20, nDrones = 5)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 10, nDrones = 2)
apiary <- addVirginQueens(apiary, nInd = 4)

getCasteId(x = drones)
getCasteId(x = colony)
getCasteId(x = apiary, caste = "workers")
getCasteId(x = apiary)
getCasteId(x = apiary, caste = "virginQueens")
# Get all IDs as a single vector
getCasteId(x = colony, caste = "all", collapse = TRUE)
getCasteId(x = apiary, caste = "workers", collapse = TRUE)
getCasteId(x = apiary, caste = "drones", collapse = TRUE)
getCasteId(x = apiary, caste = "all", collapse = TRUE)

# Create a data.frame with id, colony, and caste information
(tmpC <- getCaste(apiary[[1]]))
(tmpI <- getCasteId(apiary[[1]]))
tmp <- data.frame(caste = unlist(tmpC), id = unlist(tmpI))
head(tmp)
tail(tmp)

(tmpC <- getCaste(apiary))
(tmpI <- getCasteId(apiary))
(tmp <- data.frame(caste = unlist(tmpC), id = unlist(tmpI)))
tmp$colony <- sapply(
  X = strsplit(
    x = rownames(tmp), split = ".",
    fixed = TRUE
  ),
  FUN = function(z) z[[1]]
)
head(tmp)
tail(tmp)
}
\seealso{
\code{\link{getCaste}}

\code{\link{getCastePop}} and \code{\link{getCaste}}
}
