% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{nCsdAlleles}
\alias{nCsdAlleles}
\title{Report the number of distinct csd alleles}
\usage{
nCsdAlleles(x, collapse = FALSE, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link{Pop-class}}, \code{\link{Colony-class}}, or
\code{\link{MultiColony-class}}}

\item{collapse}{logical, if \code{TRUE}, the function will return the number
of distinct csd alleles in either the entire population, colony, or
multicolony. Note this has nothing to do with the colony collapse. It's
like \code{paste(..., collapse = TRUE)}. Default is \code{FALSE}. See
examples about this behaviour.Default is \code{FALSE}.}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}
}
\value{
integer representing the number of distinct csd alleles when \code{x}
  is \code{\link{Pop-class}} (or ), list of integer
  when \code{x} is \code{\link{Colony-class}} (list nodes named by caste) and
  list of a list of integer when \code{x} is \code{\link{MultiColony-class}},
  outer list is named by colony id when \code{x} is
  \code{\link{MultiColony-class}}; the integer rep
}
\description{
Level 0 function that returns the number of distinct csd alleles
  in input. See \code{\link{SimParamBee}} for more information about the csd
  locus.
}
\details{
Queen has 2 distinct csd alleles, since she has to be heterozygous
  to be viable. The same holds for individual virgin queens and workers, but
  note that looking at csd genotypes of virgin queens or workers we are
  looking at a sample of 1 csd allele from the queen and 1 csd allele from
  their fathers, noting that homozygous genotypes are excluded. Therefore,
  \code{nCsdAlleles()} from virgin queens and workers is a noisy realisation
  of \code{nCsdAlleles()} from queens and fathers. For this reason, we also
  report \code{nCsdAlleles()} from queens and fathers combined (see the
  \code{queenAndFathers} list node) when \code{x} is
  \code{\link{Colony-class}}. This last measure is then the expected number
  of csd alleles in a colony as opposed to realised number of csd alleles in
  a sample of virgin queens and workers. Similarly as for virgin queens and
  workers, \code{nCsdAlleles()} from drones gives a noisy realisation of
  \code{nCsdAlleles()} from queens. The amount of noise will depend on the
  number of individuals, so in most cases with reasonable number of
  individuals there should be minimal amount of noise.
}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 6, nDrones = 3)
colony <- addVirginQueens(x = colony, nInd = 4)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 6, nDrones = 3)
apiary <- addVirginQueens(x = apiary, nInd = 5)

nCsdAlleles(getQueen(colony))
nCsdAlleles(getWorkers(colony))

nCsdAlleles(colony)
nCsdAlleles(colony, collapse = TRUE)

nCsdAlleles(apiary)
nCsdAlleles(apiary, collapse = TRUE)
}
