% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_decompose_sim.R
\name{causal.decompose.sim}
\alias{causal.decompose.sim}
\title{Decomposition of simultaneous equation model}
\usage{
causal.decompose.sim(eq.system, Sigma = NULL)
}
\arguments{
\item{eq.system}{the system of equations (a list of formula objects)}

\item{Sigma}{the \eqn{\Sigma} matrix}
}
\value{
A list with components \itemize{
\item \code{output}: a list containing\itemize{
\item \code{eq.system}: the system of equations given as input
\item \code{Gamma}: the binary matrix \eqn{\Gamma^{b'}}
\item \code{C}: the binary matrix highlighting the interdependent mechanisms at deterministic level.
\item \code{Psi1}: the binary matrix highlighting the interdependent mechanisms at stochastic level.
\item \code{Psi0}: the binary matrix highlighting the causal mechanisms.
\item \code{Sigma}: the matrix \eqn{\Sigma} given as input
\item \code{all.graph}: the path diagram of the model, using the package \code{igraph}
\item \code{dec.graph}: the path diagram of the decomposed model, with color
coding for each vertex. Blue means causality, red means interdependence,
dashed red means interdependence by effect of error correlation}
\item \code{path}: a data frame in which every row is a path coefficient,
along with indication of the nature of the link (recursive/interdependent)
and the index of the equation in which it belongs
}
}
\description{
Decompose
a Simultaneous Equation Model into its recursive
and Interdependent sub-systems
}
\examples{
eq.system = list(
            eq1 = y1 ~ y5 + y7,
            eq2 = y2 ~ z,
            eq3 = y3 ~ y11,
            eq4 = y4 ~ y3,
            eq5 = y5 ~ y10,
            eq6 = y6 ~ y5 + y9,
            eq7 = y7 ~ y6,
            eq8 = y8 ~ y12,
            eq9 = y9 ~ y7,
            eq10 = y10 ~ y5,
            eq11 = y11 ~ y12,
            eq12 = y12 ~ y4 + y11,
            eq13 = y13 ~ y2 + y6)

 # indexes of non-null elements of Sigma
 sigma.idx = cbind(c(2,1),
                   c(1,5),
                   c(13,2),
                   c(2,13),
                   c(5,1),
                   c(1,2))

 #fictitious Sigma matrix
 Sigma = as.matrix(
         Matrix::sparseMatrix(i = sigma.idx[1,] , j = sigma.idx[2,], x = 0.1)) +
         diag(length(eq.system))

 causal.decompose.sim(eq.system , Sigma)
}
