% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseSIR.R
\name{project}
\alias{project}
\alias{project.sparseRes}
\title{sparse SIR}
\usage{
\method{project}{sparseRes}(object)

project(object)
}
\arguments{
\item{object}{an object of class \code{sparseRes} as obtained from the 
function \code{\link{sparseSIR}}}
}
\value{
a matrix of dimension n x d with the projection of the observations
on the d dimensions of the sparse EDR space
}
\description{
\code{project} performs the projection on the sparse EDR space (as obtained
by the \code{\link[glmnet]{glmnet}})
}
\details{
The projection is obtained by the function 
\code{\link[glmnet]{predict.glmnet}}.
}
\examples{
set.seed(1140)
tsteps <- seq(0, 1, length = 200)
nsim <- 100
simulate_bm <- function() return(c(0, cumsum(rnorm(length(tsteps)-1, sd=1))))
x <- t(replicate(nsim, simulate_bm()))
beta <- cbind(sin(tsteps*3*pi/2), sin(tsteps*5*pi/2))
beta[((tsteps < 0.2) || (tsteps > 0.5)), 1] <- 0
beta[((tsteps < 0.6) || (tsteps > 0.75)), 2] <- 0
y <- log(abs(x \%*\% beta[ ,1]) + 1) + sqrt(abs(x \%*\% beta[ ,2]))
y <- y + rnorm(nsim, sd = 0.1)
\dontrun{
res_ridge <- ridgeSIR(x, y, H = 10, d = 2)
res_sparse <- sparseSIR(res_ridge, rep(1, ncol(x)))
proj_data <- project(res_sparse)
}

}
\references{
{Picheny, V., Servien, R. and Villa-Vialaneix, N. (2016) 
Interpretable sparse SIR for digitized functional data.
\emph{Statistics and Computing}, \strong{29}(2), 255--267.}
}
\seealso{
\code{\link{sparseSIR}}
}
\author{
{Victor Picheny, \email{victor.picheny@inrae.fr}\cr
Remi Servien, \email{remi.servien@inrae.fr}\cr
Nathalie Vialaneix, \email{nathalie.vialaneix@inrae.fr}}
}
