% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepp.R
\name{stepp}
\alias{stepp}
\title{Stepp}
\usage{
stepp(
  x,
  M = 100,
  lmax = 5,
  alpha = 0.95,
  dismethod = "ACF",
  clumethod = "complete"
)
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{M}{Number of simulation realizations. Default value is 100.}

\item{lmax}{Number of lags used (for ACF, PACF, AR-coefficient). Default value is 5.}

\item{alpha}{Quantile used in the plotting. Default value is 0.95.}

\item{dismethod}{Summary statistics of each time series to be used in computing distance.
Choices include “ACF”, “PACF”, “AR.PIC” and “PER”. Default is "ACF".}

\item{clumethod}{Hierarchical clustering method:
choices include “single”, “average”, and “complete”. Default is “complete”.}
}
\value{
Two plots are given in output:

The first plot shows the “height” of the dendrogram. Solid line is the observed
height. The points denote the alpha quantile of heights based on the simulated series.

The second plot shows the “step” of the dendrogam (increments of heights).
Solid line is the observed increments and the points are those of selected quantile
for the simulated series.

A list containing:
\itemize{
\item mh - alpha quantile of heights based on the simulated series.
\item mdh - increments of selected quantile for the simulated series.
\item hgt - observed height.
\item hgtincre - observed increments.
\item Mh - the alpha quantile of the results of the M simulations are reported.
}
}
\description{
To compute and plot the observed and simulated distances for measuring similarity between time series.
The distance can be computed using ACF, PACF, AR-coefficients, or Periodogram.
}
\details{
The Empirical Dynamic Quantile of the series is obtained, a set of
Txk series is generated and the heights in the dendrogram are obtained.
This is repeated M times and the alpha quantile of the results of
the M simulations are reported. Both dendrogram's heights and steps
(differences) of these heights are compared.
}
\examples{
data(TaiwanAirBox032017)
output <- stepp(as.matrix(TaiwanAirBox032017[,1:50]), M = 2)

}
