% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chktrans.R
\name{chktrans}
\alias{chktrans}
\title{Check for Possible Non-linear Transformations of a Multiple Time Series}
\usage{
chktrans(x, block = 0, output = FALSE, period = 1, pv = 0.05)
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{block}{Number of blocks used in the linear regression. Default value is floor(sqrt(T)).}

\item{output}{If TRUE it returns the estimates, the code: log, sqrt and No-trans and
the numbers of non-linear transformations. Default is TRUE.}

\item{period}{Seasonal period.}

\item{pv}{P-value = pv/log(1 + k) is used to check the significance of the coefficients.
Default value is 0.05.}
}
\value{
A list containing:
\itemize{
   \item lnTran - Column locations of series that require log-transformation.
   \item sqrtTran - Column locations of series that require square-root transformation.
   \item noTran - Column locations of series that require no transformation.
   \item tran - A vector indicating checking results, where 0 means no transformation,
   1 means log-transformation, 2 means square-root transformation.
   \item tranX Transformed series. This is only provided if the number of series
   requiring transformation is sufficiently large, i.e. greater than \eqn{2kpv}.
   \item Summary Number of time series that require log-transformation,
   square-root transformation and no transformation.
}
}
\description{
Check for possible non-linear transformations of a multiple time series, series by series.
}
\details{
Each series is divided into a given number of consecutive blocks and in each of them
the mean absolute deviation (MAD) and the median are computed. A regression of
the log of the MAD with respect to the log of the median is run and the slope defines
the non-linear transformation.
}
\examples{
data(TaiwanAirBox032017)
output <- chktrans(TaiwanAirBox032017[,1])

}
