% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IUPM.R
\name{get.iupm}
\alias{get.iupm}
\title{IUPM, PGOF, and CI}
\usage{
get.iupm(pos, replicates, dilutions, monte = 15000, conf.level = 0.95)
}
\arguments{
\item{pos}{Vector of number of positive wells at each dilution level (outcome of SLD Assay)}

\item{replicates}{Vector of number of replicates at each dilution level}

\item{dilutions}{Vector of number of cells per well at each dilution level}

\item{monte}{Number of Monte Carlo samples. Default is exact (no MC sampling), unless
more than 15,000 possible positive well outcomes exist, in which case 15,000 MC samples are taken.
 Use monte=F for exact computation.}

\item{conf.level}{Confidence level of the interval.}
}
\value{
\item{IUPM_MLE}{Maximum likelihood estimate of IUPM for the given outcome vector.}

\item{Exact_PGOF}{P value for goodness of fit. PGOF is the probability of an
experimental result as rare as or rarer than that obtained, assuming that the model is
correct. Low values of PGOF, (e.g. PGOF < 0.01), indicate rare or implausible experimental
results. Samples with a very low PGOF might be considered for retesting.}

\item{Asymp_PGOF}{P value calculated using an asymptotic Chi-Squared distribution with D-1 degrees of freedom,
where D is the number of dilution levels in an SLD assay.}

\item{Exact_CI}{Exact confidence interval, computed from the likelihood ratio test (recommended)}

\item{Asymp_CI}{Wald asymptotic confidence interval, based on the normal approximation to the binomial distribution.}
}
\description{
Calculates the maximum likelihood estimate of infectious units per million (IUPM)
from a single serial limiting dilution (SLD) assay. Also calculates corresponding
exact and asymptotic confidence intervals, and a goodness-of-fit p-value. While
this package was developed with the purpose of estimating IUPM, it is applicable to SLD
assays in general.
}
\examples{
# Duplicates row 4 of Table 4 from Myers, et. al.
# Myers et. al. divides IUPM space into discrete values. This package searches
# entire parameter space, yielding a slightly different and more accurate MLE.
row4 <- get.iupm(pos=c(2,1,0,0,0,0),  # Number of positive wells per dilution level
                 replicates=rep(2,6), # Number of replicates per dilution level
                 dilutions=c(1e6,2e5,4e4,8e3,1600,320), # Cells per dilution level
                 conf.level=0.95   # Significance level
                 )

# Duplicates row 21 of Table 4 from Myers, et. al.
# Low PGOF example
# Myers et. al. divides IUPM space into discrete values. This package searches
# entire parameter space, yielding a slightly different and more accurate MLE.
row21 <- get.iupm(pos=c(2,2,2,0,1,0),
                 replicates=rep(2,6),
                 dilutions=c(1e6,2e5,4e4,8e3,1600,320),
                 conf.level=0.95 )

# Monte Carlo example
# 67,081 total possible positive well outcomes, therefore
# Monte Carlo sampling is used to reduce computation time.
MC.example <- get.iupm(pos=c(30,9,1,0),
                       replicates=c(36,36,6,6),
                       dilutions=c(2.5e6,5e5,1e5,2.5e4),
                       conf.level=0.95,
                       monte = 5000 )
}
\references{
Myers, L. E., McQuay, L. J., & Hollinger, F. B. (1994). Dilution assay statistics.
            Journal of Clinical Microbiology, 32(3), 732-739. DOI:10.1.1.116.1568
}

