% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-Prediction.R
\name{predict_and_evaluate}
\alias{predict_and_evaluate}
\title{Predict using the SLOS model}
\usage{
predict_and_evaluate(data)
}
\arguments{
\item{data}{A data frame or matrix of new data for prediction.}
}
\value{
A list containing the predictions made on the input data, a data frame combining the observed values and predictions side by side, and the RMSE, MAE, and R2.
}
\description{
This function makes predictions using the pre-trained SLOS model and evaluates it based on RMSE, MAE, and R2 values.
}
\examples{
\donttest{
# Load example data
data(SampledData)

# Make predictions and evaluate
results <- predict_and_evaluate(sampled_data)

# View results
print(results$RMSE)
print(results$MAE)
print(results$R2)
}
}
