% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maptt.R
\name{maptt}
\alias{maptt}
\title{maptt}
\usage{
maptt(
  data,
  multipleValuesByTime = c(),
  circleRadius = 6,
  defaultNodeColor = "steelblue",
  nodeColorByState = list(),
  moveEdgeColor = "steelblue",
  color1 = "green",
  color2 = "red",
  nbColors = 10,
  minWeight = 0,
  maxWeight = 1,
  weight1 = 0,
  weight2 = 1,
  autoFocus = TRUE,
  keepOldFeatures = TRUE,
  optionsControl = TRUE,
  gradientControl = TRUE,
  legend = TRUE,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{Either a data frame that will be converted to a GeoJSON
collection, or a string describing a valid GeoJSON collection.
The data frame must contain at least columns 'id', 'time', 'X' and 'Y'.
It can contain columns 'infectedby', 'probabilities'.
Additionnal columns will be added as properties, but will do nothing
in this implementation of maptt.
See the `df2geojson` function for more informations.}

\item{multipleValuesByTime}{Vector of strings indicating the df columns names which can contain several values by time. Typically, you would use `c('infectedby','probabilities')` if you have these values.}

\item{circleRadius}{Numeric value specifying the radius of the nodes in pixels.}

\item{defaultNodeColor}{String indicating the default color of nodes, if their status doesn't match whith any color. Colors can be specified in hex.}

\item{nodeColorByState}{List of strings, indicating the color scheme for each node state.}

\item{moveEdgeColor}{String indicating the color of the edges representing the move of a node.}

\item{color1}{String indicating the color corresponding to the minWeight value.}

\item{color2}{String indicating the color corresponding to the maxWeight value.}

\item{nbColors}{Number of colors for the color scheme using a gradient between color1 and color2. These colors will be used to represent the infection edges according to the infection probability. If no probability is used, the edge will use color2. Three intervals are created :
color1 will be used for the probabilities between minWeight and weight1.
Colors between color1 and color2 will be used for probabilities between weight1 and weight2.
color2 will be used for probabilities between weight2 and maxWeight.
This setting can be modified directly on the map if 'gradientControl' is activated.}

\item{minWeight}{Minimal weight.}

\item{maxWeight}{Maximal weight.}

\item{weight1}{Lowest weight for the color scheme. This setting can be modified directly on the map if 'gradientControl' is activated.}

\item{weight2}{Greatest weight for the color scheme. This setting can be modified directly on the map if 'gradientControl' is activated.}

\item{autoFocus}{Boolean indicating if the map should focus at the displayed features at each time. This setting can be toggled directly on the map if 'optionsControl' is activated.}

\item{keepOldFeatures}{Boolean indicating if old features should be displayed or not. Features are considered "old" if their last 'time' is prior to the current time displayed. This setting can be toggled directly on the map if 'optionsControl' is activated.}

\item{optionsControl}{Boolean indicating if the options control should be displayed or not}

\item{gradientControl}{Boolean indicating if the gradient control should be displayed or not}

\item{legend}{Boolean indicating if the legend should be displayed or not}

\item{width}{Numeric width for the area in pixels.}

\item{height}{Numeric hieght for the area in pixels.}

\item{elementId}{The element ID where the map is displayed}
}
\description{
Display a Transmission Tree over a map.
}
\examples{
library(SMITIDvisu)
data(transmissiontree)

maptt(tt.events, multipleValuesByTime = c('infectedby', 'probabilities'))

# In this example:
# - values lower than 20 will be yellow ;
# - values between 20 and 25 will use colors between yellow and red ;
# - values greater than 25 will be red.
maptt(tt.events,
 multipleValuesByTime = c('infectedby', 'probabilities'),
 color1 = 'yellow',
 color2 = 'red',
 nbColors = 10,
 minWeight = 0,
 maxWeight = 30,
 weight1 = 20,
 weight2 = 25
)

}
