#' Print function for simulated data
#' @importFrom utils capture.output
#' @description This functions prints a summary of a data set generated by
#' Gen_data.
#'
#' In particular, it prints the indices of relevant features, true model
#' coefficients, and the correlation structure.
#'
#'
#' @param x \code{"sdata"} object from Gen_Data function.
#'
#' @param ... This argument is not used and listed for method consistency.
#'
#' @return
#'
#' No return value, called for side effects.
#'
#' @export
#'
#' @method print sdata
#'
#' @examples
#' Data<-Gen_Data(family ="binomial",correlation = "ID")
#' cor(Data$X[,1:10])
#' print(Data)
print.sdata<-function(x,...){


  if(is.null(x$index)){

    Description<-data.frame("Dim_of_Y" = paste(c(length(x$Y),1),collapse = ' x '),
                                               "Dim_of_X" = paste(dim(x$X),collapse = ' x '),
                                               "Model_Type"= .simpleCap(x$family)
  )
  }else{
    Description<-data.frame("Dim_of_Y" = paste(c(length(x$Y),1),collapse = ' x '),
                                  "Dim_of_X" = paste(dim(x$X),collapse = ' x '),
                                  "Model_Type"= .simpleCap(x$family),
                                  "Relevant_features"=paste("V",x$index[order(x$index, decreasing = FALSE)],sep='',collapse=' '),
                                  "Coefficient" = paste(format(x$Beta, digits = 3),collapse = ' '),
                                  "Correlation" = .simpleCap(x$correlation)
  )}

  if(x$Cate==TRUE){
    Ci<-(1:dim(x$X)[2])[sapply(x$X,is.factor)]
    nlevel<-sapply(x$X[,Ci],nlevels)

    Description<-cbind(Description,
                                      "Categorical_features"=paste("C",Ci,sep='',collapse=' '),
                                      "Level_of_categories" =paste(nlevel,sep='',collapse=' ')
    )}

  message(paste0(capture.output(t(Description)), collapse = "\n"))
}

