% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMMA_predict.R
\name{predict.SMMA}
\alias{predict.SMMA}
\title{Make Prediction From a SMMA Object}
\usage{
\method{predict}{SMMA}(object, x = NULL, X = NULL, ...)
}
\arguments{
\item{object}{An object of class SMMA, produced with \code{softmaximin}}

\item{x}{a matrix of size \eqn{n' \times p} with \eqn{n'} is the number of new data points.}

\item{X}{a list containing the data matrices each of size \eqn{n'_{i} \times p_i},
where \eqn{n'_{i}} is the number of new data points in  the \eqn{i}th dimension.}

\item{...}{ignored}
}
\value{
A list of length \code{nlambda} containing the linear predictors for each  model. If
new covariate data is supplied in one \eqn{n' \times p} matrix \code{x} each
item  is a vector of length \eqn{n'}. If the data is supplied as a list of
matrices each of size \eqn{n'_{i} \times p_i},  each item is an array of size \eqn{n'_1 \times \cdots \times n'_d}, with \eqn{d\in \{1,2,3\}}.
}
\description{
Given new covariate data this function computes the linear predictors
based on the estimated model coefficients in an object produced by the function \code{softmaximin}. Note that the
data can be supplied in two different formats: i) as a \eqn{n' \times p} matrix (\eqn{p} is the number of model
coefficients and \eqn{n'} is the number of new data points) or ii) as a list of two or three matrices each of
size \eqn{n_i' \times p_i, i = 1, 2, 3} (\eqn{n_i'} is the number of new marginal data points in the \eqn{i}th dimension).
}
\examples{

##size of example
n1 <- 65; n2 <- 26; n3 <- 13; p1 <- 13; p2 <- 5; p3 <- 4

##marginal design matrices (Kronecker components)
X1 <- matrix(rnorm(n1 * p1, 0, 0.5), n1, p1)
X2 <- matrix(rnorm(n2 * p2, 0, 0.5), n2, p2)
X3 <- matrix(rnorm(n3 * p3, 0, 0.5), n3, p3)
X <- list(X1, X2, X3)

component <- rbinom(p1 * p2 * p3, 1, 0.1)
Beta1 <- array(rnorm(p1 * p2 * p3, 0, .1) + component, c(p1 , p2, p3))
Beta2 <- array(rnorm(p1 * p2 * p3, 0, .1) + component, c(p1 , p2, p3))
mu1 <- RH(X3, RH(X2, RH(X1, Beta1)))
mu2 <- RH(X3, RH(X2, RH(X1, Beta2)))
Y1 <- array(rnorm(n1 * n2 * n3, mu1), dim = c(n1, n2, n3))
Y2 <- array(rnorm(n1 * n2 * n3, mu2), dim = c(n1, n2, n3))

Y <- array(NA, c(dim(Y1), 2))
Y[,,, 1] <- Y1; Y[,,, 2] <- Y2;

fit <- softmaximin(X, Y, zeta = 10, penalty = "lasso", alg = "npg")

##new data in matrix form
x <- matrix(rnorm(p1 * p2 * p3), nrow = 1)
predict(fit, x = x)[[15]]

##new data in tensor component form
X1 <- matrix(rnorm(p1), nrow = 1)
X2 <- matrix(rnorm(p2), nrow = 1)
X3 <- matrix(rnorm(p3), nrow = 1)
predict(fit, X = list(X1, X2, X3))[[15]]


}
\author{
Adam Lund
}
