% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RUS.R
\name{RUS}
\alias{RUS}
\title{Random Undersampling (RUS)}
\usage{
RUS(x, y)
}
\arguments{
\item{x}{feature matrix.}

\item{y}{a factor class variable with two classes.}
}
\value{
a list with resampled dataset.
 \item{x_new}{Resampled feature matrix.}
 \item{y_new}{Resampled target variable.}
}
\description{
Resampling with RUS.
}
\details{
Random Undersampling (RUS) is a method of removing negative
samples until balance is achieved.
}
\examples{

set.seed(1)
x <- rbind(matrix(rnorm(2000, 3, 1), ncol = 2, nrow = 1000),
           matrix(rnorm(100, 5, 1), ncol = 2, nrow = 50))
y <- as.factor(c(rep("negative", 1000), rep("positive", 50)))

plot(x, col = y)

# resampling
m <- RUS(x = x, y = y)

plot(m$x_new, col = m$y_new)

}
\author{
Fatih Saglam, saglamf89@gmail.com
}
