% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMOTE.R
\name{GSMOTE}
\alias{GSMOTE}
\title{Geometric Synthetic Minority Oversamplnig Technique (GSMOTE)}
\usage{
GSMOTE(
  x,
  y,
  k = 5,
  alpha_sel = "combined",
  alpha_trunc = 0.5,
  alpha_def = 0.5,
  n_needed = NULL
)
}
\arguments{
\item{x}{feature matrix.}

\item{y}{a factor class variable with two classes.}

\item{k}{number of neighbors. Default is 5.}

\item{alpha_sel}{selection method. Can be "minority", "majority" or "combined".
Default is "combined".}

\item{alpha_trunc}{truncation factor. A numeric value in \eqn{[-1,1]}.
Default is 0.5.}

\item{alpha_def}{deformation factor. A numeric value in \eqn{[0,1]}.
Default is 0.5}

\item{n_needed}{vector of desired number of synthetic samples for each class.
A vector of integers for each class. Default is NULL meaning full balance.}
}
\value{
a list with resampled dataset.
 \item{x_new}{Resampled feature matrix.}
 \item{y_new}{Resampled target variable.}
 \item{x_syn}{Generated synthetic feature data.}
 \item{y_syn}{Generated synthetic label data.}
}
\description{
Resampling with GSMOTE.
}
\details{
GSMOTE (Douzas & Bacao, 2019) is an oversampling method which creates synthetic
samples geometrically around selected minority samples. Details are in the
paper (Douzas & Bacao, 2019).

Can work with classes more than 2.
}
\examples{

set.seed(1)
x <- rbind(matrix(rnorm(2000, 3, 1), ncol = 2, nrow = 1000),
           matrix(rnorm(100, 5, 1), ncol = 2, nrow = 50))
y <- as.factor(c(rep("negative", 1000), rep("positive", 50)))

plot(x, col = y)

# resampling
m <- GSMOTE(x = x, y = y, k = 7)

plot(m$x_new, col = m$y_new)

}
\references{
Douzas, G., & Bacao, F. (2019). Geometric SMOTE a geometrically enhanced
drop-in replacement for SMOTE. Information sciences, 501, 118-135.
}
\author{
Fatih Saglam, saglamf89@gmail.com
}
