% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary_print_Uni.R
\name{summary.SNSeg_Uni}
\alias{summary.SNSeg_Uni}
\title{Summary of SN-based change-point estimates for univariate or bivariate time
series (testing the change in correlation between bivariate time series)}
\usage{
\method{summary}{SNSeg_Uni}(object, ...)
}
\arguments{
\item{object}{a \code{SNSeg_Uni} object}

\item{...}{not in use}
}
\description{
Summary method for objects of class \code{SNSeg_Uni}
}
\details{
Provide information about estimated change-point locations, the
parameter tested by SN-based procedures, the confidence level, the \code{grid_size},
and the critical value of the SN-based test.
}
\examples{
\donttest{
set.seed(7)
ts <- MAR_Variance(2, "V1")
ts <- ts[,2]
# test the change in a single parameter (variance)
# grid_size defined
result <- SNSeg_Uni(ts, paras_to_test = "variance", confidence = 0.9,
                    grid_size_scale = 0.05, grid_size = 67,
                    plot_SN = FALSE, est_cp_loc = TRUE)
summary(result)
}

}
