% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_taxonID.R
\name{search_taxonID}
\alias{search_taxonID}
\title{Search taxon IDs}
\format{
query:
\describe{
\item{taxonIDs}{an array of species' ids}
\item{familyID}{family ID, unique value}
\item{scientificName}{the scientific name, or part of the scientific name, supports Latin names and Chinese}
\item{commonName}{common name, or part of common name}
}
}
\usage{
search_taxonID(query = NULL, name = "scientificName", mc.cores = 2)
}
\arguments{
\item{query}{\code{string} familyID ,scientificName or commonName.}

\item{name}{\code{character} name=c("familyID","scientificName","commonName"),the default value is "scientificName".}

\item{mc.cores}{The number of cores to use, i.e. at most how many child processes will be run simultaneously. The option is initialized from environment variable MC_CORES if set. Must be at least one, and parallelization requires at least two cores,see [mclapply] for details.}
}
\value{
dataframe
}
\description{
Search taxon IDs via familyID ,scientificName and commonName.
}
\details{
Visit the website \url{http://sp2000.org.cn/api/document} for more details
}
\examples{
\dontrun{
search_taxonID(query = "Uncia uncia",name = "scientificName")
queries <- c("Anguilla marmorata","Uncia uncia")
search_taxonID(query = queries,name = "scientificName")

x1 <- search_familyID(query = "Cyprinidae")
x2 <- search_taxonID(query = x1$familyIDs,name = "familyID")
x2$family <- rep(x1$family,dim(x2)[1])
}
}
\author{
Liuyong Ding
}
