% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designUniformRandom.R
\name{designUniformRandom}
\alias{designUniformRandom}
\title{Uniform Design Generator}
\usage{
designUniformRandom(x = NULL, lower, upper, control = list())
}
\arguments{
\item{x}{optional data.frame x to be part of the design}

\item{lower}{vector with lower boundary of the design variables (in case of categorical parameters, please map the respective factor to a set of contiguous integers, e.g., with lower = 1 and upper = number of levels)}

\item{upper}{vector with upper boundary of the design variables (in case of categorical parameters, please map the respective factor to a set of contiguous integers, e.g., with lower = 1 and upper = number of levels)}

\item{control}{list of controls:\cr
\code{size} number of design points\cr
\code{types} this specifies the data type for each design parameter, as a vector of either "numeric","integer","factor". (here, this only affects rounding)\cr
\code{replicates} integer for replications of each design point. E.g., if replications is two, every design point will occur twice in the resulting matrix.}
}
\value{
matrix \code{design} \cr
- \code{design} has \code{length(lower)} columns and \code{(size + nrow(x))*control$replicates} rows.
All values should be within \code{lower <= design <= upper}
}
\description{
Create a simple experimental design based on uniform random sampling.
}
\examples{
set.seed(1) #set RNG seed to make examples reproducible
design <- designUniformRandom(,1,2) #simple, 1-D case
design
design <- designUniformRandom(,1,2,control=list(replicates=3)) #with replications
design
design <- designUniformRandom(,c(-1,-2,1,0),c(1,4,9,1),
		control=list(size=5, types=c("numeric","integer","factor","factor")))
design
x <- designUniformRandom(,c(1,-10),c(2,10),control=list(size=5))
x2 <- designUniformRandom(x,c(1,-10),c(2,10),control=list(size=5))
plot(x2)
points(x, pch=19)
}
