% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeatsOCBA.R
\name{repeatsOCBA}
\alias{repeatsOCBA}
\title{Optimal Computing Budget Allocation}
\usage{
repeatsOCBA(x, y, budget)
}
\arguments{
\item{x}{matrix of samples. Identical rows indicate repeated evaluations. Any sample should be evaluated at least twice, to get an estimate of the variance.}

\item{y}{observations of the respective samples. For repeated evaluations, y should differ (variance not zero).}

\item{budget}{of additional evaluations to be allocated to the samples.}
}
\value{
A vector that specifies how often each solution should be evaluated.
}
\description{
A simple interface to the Optimal Computing Budget Allocation algorithm.
}
\examples{
x <- matrix(c(1:3,1:3),9,2)
y <- runif(9)
repeatsOCBA(x,y,10)
}
\references{
Chun-hung Chen and Loo Hay Lee. 2010. Stochastic Simulation Optimization: An Optimal Computing Budget Allocation (1st ed.). World Scientific Publishing Co., Inc., River Edge, NJ, USA.
}
\seealso{
repeatsOCBA calls \code{\link{OCBA}}, which also provides some additional details.
}
