% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funContinuous.R
\name{funSoblev99}
\alias{funSoblev99}
\title{Sobol and Levitan Test Function (No. 6)}
\usage{
funSoblev99(x, b = c(rep(0.6, 10), rep(0.4, 10)), c0 = 0)
}
\arguments{
\item{x}{(\code{m,2})-matrix of points to evaluate with the function.
Values should be >= 0 and <= 1, i.e., x_i in [0,1].}

\item{b}{d-dimensional vector (optional), with default value
b = c(0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6,
0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4) (when d<=20)}

\item{c0}{constant term (optional), with default value 0}
}
\value{
1-column matrix with resulting function values
}
\description{
An implementation of the Sobol-Levitan function.

f(x) = exp(sum b_i x_i) - I_d + c_0, where
       I_d = prod( (exp(b_i) -1) / b_i)

The value of the elements in the b-vector (b1, ..., bd) affect the importance
of the corresponding x-variables.
Sobol' & Levitan (1999) use two different b-vectors:
  (1.5, 0.9, 0.9, 0.9, 0.9, 0.9), for d = 6, and
  (0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.4, 0.4, 0.4, 0.4, 0.4,
   0.4, 0.4, 0.4, 0.4, 0.4), for d = 20.
Our implementation uses the default b vector:
 b = c(0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6,
     0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4, 0.4) (when d<=20).

Moon et al. (2012) scale the output to have a variance of 100.
For d = 20, they use three different b-vectors:
  (2, 1.95, 1.9, 1.85, 1.8, 1.75, 1.7, 1.65, 0.4228, 0.3077, 0.2169, 0.1471,
   0.0951, 0.0577, 0.0323, 0.0161, 0.0068, 0.0021, 0.0004, 0),
  (1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), and
  (2.6795, 2.2289, 1.8351, 1.4938, 1.2004, 0.9507, 0.7406, 0.5659, 0.4228,
   0.3077, 0.2169, 0.1471, 0.0951, 0.0577, 0.0323, 0.0161, 0.0068, 0.0021, 0.0004, 0).

The generally used value of c0 is c0 = 0.
The function is evaluated on xi in [0, 1], for all i = 1, ..., d.
}
\examples{
x1 <- matrix(c(-pi, 12.275),1,)
funSoblev99(x1)

}
\references{
Moon, H., Dean, A. M., & Santner, T. J. (2012).
Two-stage sensitivity-based group screening in computer experiments.
Technometrics, 54(4), 376-387.

Sobol', I. M., & Levitan, Y. L. (1999). On the use of variance reducing
multipliers in Monte Carlo computations of a global sensitivity index.
Computer Physics Communications, 117(1), 52-61.
}
