% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funContinuous.R
\name{makeMoreFunList}
\alias{makeMoreFunList}
\title{makeMoreFunList}
\usage{
makeMoreFunList(vector2Matrix = TRUE)
}
\arguments{
\item{vector2Matrix}{logical. Convert vector input to matrix.
Default: TRUE, so it can be used with \code{\link[stats]{optim}}.}
}
\value{
list of functions with starting points and optimum points.
}
\description{
Generate a list of benchmark functions.
Based on the More(1981) paper.
Contains the first 13 function from the paper.
Function numbers are the same as in the paper.
}
\examples{
# Generate function list.
# Here we use the default setting \code{vector2Matrix = TRUE},
# so the function list can be passed to \code{\link[stats]{optim}}.

fl <- makeMoreFunList()
optim(par=c(-1.2,1), fn=fl$funList[[1]])
optim(par=fl$startPointList[[1]], fn=fl$funList[[1]])$value
optim(par=fl$startPointList[[1]], fn=fl$funList[[1]],NULL, method = "CG", hessian = FALSE)$value
optim(fl$startPointList[[1]], fl$funList[[1]],NULL, method = "BFGS", hessian = FALSE)$value
optim(fl$startPointList[[1]], fl$funList[[1]],NULL, method = "L-BFGS-B", hessian = FALSE)$value

}
\references{
More, J. J., Garbow, B. S., and  Hillstrom, K. E. (1981).
Testing unconstrained optimization software.
\emph{ACM Transactions on Mathematical Software (TOMS)}, \emph{7}(1), 17-41.
\doi{10.1145/355934.355936}
}
