% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funBabsimHospital.R
\name{funBaBSimHospital}
\alias{funBaBSimHospital}
\title{Optimization of the BaBSim.Hospital Simulator}
\usage{
funBaBSimHospital(
  x,
  region = 5374,
  nCores = 2,
  verbosity = 0,
  rkiEndDate = "2020-12-09",
  icuEndDate = "2020-12-09",
  trainingWeeksSimulator = 10,
  trainingWeeksField = 6,
  totalRepeats = 10
)
}
\arguments{
\item{x}{\code{matrix} of points to evaluate with the simulator. 
Rows for points and columns for dimension.}

\item{region}{\code{integer}. Represents the region code. Default: 5374 (Oberberg).}

\item{nCores}{\code{integer}. Defines the number of cores.}

\item{verbosity}{\code{integer}. Handles output. Default: 0}

\item{rkiEndDate}{\code{characters}. Last day of rki data. Default \code{"2020-12-09"}}

\item{icuEndDate}{\code{characters}. Last day of icu data. Default \code{"2020-12-09"}}

\item{trainingWeeksSimulator}{\code{integer}. Training period using rki data. Default: 10. Should be larger than \code{trainingWeeksField}.}

\item{trainingWeeksField}{\code{integer}. Training period using icu data. Default: 6. Should be smaller than \code{trainingWeeksSimulator}.}

\item{totalRepeats}{\code{integer}. Number of repeats for each configuration. Should be a multiple of \code{nCores}. Default: 10.}
}
\value{
y \code{numeric} function value.
}
\description{
\code{funBaBSimHospital} implements an interface to the 
\code{babsim.hospital} package.
\code{babsim.hospital} is a discrete-event simulation model 
for a hospital resource planning problem.  
The project is motivated by the challenges faced by health care institutions in 
the COVID-19 pandemic. 
It can be used by health departments to forecast demand for intensive care beds, 
ventilators, and staff resources.
\code{funBaBSimHospital} provides an interface to \code{\link[babsim.hospital]{getTrainTestObjFun}}.
}
\examples{
## babsim.hospital version must be greater equal 11.7:
# ver <-  unlist(packageVersion("babsim.hospital"))
# if( ver[1] >= 11 & ver[2] >= 7){
#    x <- matrix(as.numeric(babsim.hospital::getParaSet(5374)[1,-1]),1,)
#    funBaBSimHospital(x)
#    }
}
