% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spot.R
\name{spotLoop}
\alias{spotLoop}
\title{Sequential Parameter Optimization Main Loop}
\usage{
spotLoop(x, y, fun, lower, upper, control, ...)
}
\arguments{
\item{x}{\code{(m,n) matrix} that contains the known candidate solutions.
The SPOT loop is started with these values. Each row represents one \code{n} dimensional
data point. Each of the \code{m} columns represents one optimized parameter.}

\item{y}{\code{(m,p) matrix} that represents observations for each point in \code{x},
Each of the \code{m} rows represents solutions for one data point.}

\item{fun}{\code{function} that represents the objective function.
It should receive a matrix \code{x} and return a matrix \code{y}.
In case the function uses external code and is noisy, an additional seed parameter may be used,
see the \code{control$seedFun} argument below for details.}

\item{lower}{is a vector that defines the lower boundary of search space.
This determines also the dimension of the problem.}

\item{upper}{is a vector that defines the upper boundary of search space.}

\item{control}{is a list with control settings for spot. See \code{\link{spotControl}}.}

\item{...}{additional parameters passed to \code{fun}.}
}
\value{
This function returns a list with:
\describe{
	\item{{xbest}}{Parameters of the best found solution (matrix).}
	\item{\code{ybest}}{Objective function value of the best found solution (matrix).}
	\item{\code{x}}{Archive of all evaluation parameters (matrix).}
	\item{\code{y}}{Archive of the respective objective function values (matrix).}
	\item{\code{count}}{Number of performed objective function evaluations.}
	\item{\code{msg}}{Message specifying the reason of termination.}
	\item{\code{modelFit}}{The fit of the last build model, i.e.,
	an object returned by the last call to the function specified by \code{control$model}.}
}
}
\description{
SPOT is usually started via the function \code{\link{spot}}. However, SPOT runs can be continued
(i.e., with a larger budget specified in \code{control$funEvals}) by using \code{spotLoop}.
This is the main loop of SPOT iterations. It requires the user to give the same inputs as
specified for \code{\link{spot}}. Note: \code{control$funEvals} must be larger than the value
used in the previous run, because it specifies the total number of function evaluations and
not the additional number of evalutions.
}
\examples{
## Most simple example: Kriging + LHS + predicted
## mean optimization (not expected improvement)
\donttest{
control <- list(funEvals=20)
res <- spot(,funSphere,c(-2,-3),c(1,2),control)
## now continue with larger budget.
## 5 additional runs will be performed.
control$funEvals <- 25
res2 <- spotLoop(res$x,res$y,funSphere,c(-2,-3),c(1,2),control)
res2$xbest
res2$ybest
}
}
