% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotPlot.R
\name{plotSensitivity}
\alias{plotSensitivity}
\title{Sensitivity ggplot of a model}
\usage{
plotSensitivity(
  object,
  s = 100,
  xlab = paste("x", 1:ncol(object$x), sep = ""),
  ylab = "y",
  type = "best",
  agg.sample = 100,
  agg.fun = mean,
  ...
)
}
\arguments{
\item{object}{the result list returned by
\code{\link[SPOT]{spot}}, importantly including a \code{modelFit}, and the data \code{x}, \code{y}.}

\item{s}{number of samples along each dimension.}

\item{xlab}{a vector of characters, giving the labels for each of the two independent variables.}

\item{ylab}{character, the value of the dependent variable predicted by the corresponding model.}

\item{type}{string describing the type of the plot:
\code{"best"} (default) shows sensitivity around optimum,
\code{"contour"},}

\item{agg.sample}{number of samples for aggregation type
(type="agg").}

\item{agg.fun}{function for aggregation (type="agg").}

\item{...}{additional parameters (currently unused).}
}
\value{
ggplot2 visualization
}
\description{
Sensitivity ggplot of a model
}
\seealso{
\code{\link[SPOT]{plotFunction}},
\code{\link[SPOT]{plotData}}
}
