% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startMnistRun.R
\name{startMnistRun}
\alias{startMnistRun}
\title{Start hyperparameter optimization runs with spot based on MNIST data}
\usage{
startMnistRun(
  runNr = "000",
  SPOTVersion = "2.11.4",
  SPOTMiscVersion = "1.19.6",
  encoding = "tensor",
  network = "cnn",
  timebudget = 60,
  data.seed = 1,
  prop = 2/3,
  batch_size = 32,
  tuner.seed = 1,
  returnValue = "validationLoss",
  initSizeFactor = 1,
  spotModel = buildKriging,
  spotOptim = optimDE,
  lower = NULL,
  upper = NULL,
  noise = TRUE,
  OCBA = FALSE,
  OCBABudget = 0,
  multiStart = 2,
  multFun = 200,
  handleNAsMethod = handleNAsMean,
  imputeCriteriaFuns = list(is.infinite, is.na, is.nan),
  krigingTarget = "ei",
  krigingUseLambda = TRUE,
  krigingReinterpolate = TRUE,
  defaultAsStartingPoint = TRUE,
  plots = FALSE,
  Rinit = 1,
  replicates = 1,
  resDummy = FALSE,
  verbosity = 0
)
}
\arguments{
\item{runNr}{character, specifies the run number. Default: \code{"000"}}

\item{SPOTVersion}{smallest package version number}

\item{SPOTMiscVersion}{smallest package version number}

\item{encoding}{encoding: \code{"oneHot"} od \code{"tensor"}. Default: \code{"tensor"}}

\item{network}{network: \code{"dl"} odr \code{"cnn"}. Default: \code{"cnn"}}

\item{timebudget}{time budget Default:  \code{3600} (secs)}

\item{data.seed}{1}

\item{prop}{proportion 2 / 3}

\item{batch_size}{batch size (for dl) 32}

\item{tuner.seed}{seed for SPOT  1}

\item{returnValue}{"validationLoss"}

\item{initSizeFactor}{multiplier for the initial design size 2}

\item{spotModel}{buildKriging}

\item{spotOptim}{optimDE}

\item{lower}{NULL}

\item{upper}{NULL}

\item{noise}{TRUE}

\item{OCBA}{TRUE}

\item{OCBABudget}{3}

\item{multiStart}{2}

\item{multFun}{200}

\item{handleNAsMethod}{handleNAsMean}

\item{imputeCriteriaFuns}{list(is.infinite, is.na, is.nan)}

\item{krigingTarget}{"ei"}

\item{krigingUseLambda}{TRUE}

\item{krigingReinterpolate}{FALSE}

\item{defaultAsStartingPoint}{FALSE}

\item{plots}{FALSE}

\item{Rinit}{2}

\item{replicates}{2}

\item{resDummy}{FALSE}

\item{verbosity}{0}
}
\description{
Runs to compare deep learning models. Note: Number of epochs is
limited: \code{model <- "dl"; cfg <- getModelConf(model = model); cfg$upper[6] <- 5}
}
\examples{
\donttest{
### These examples require an activated Python environment as described in
### Bartz-Beielstein, T., Rehbach, F., Sen, A., and Zaefferer, M.:
### Surrogate Model Based Hyperparameter Tuning for Deep Learning with SPOT,
### June 2021. http://arxiv.org/abs/2105.14625.
PYTHON_RETICULATE = FALSE
if(PYTHON_RETICULATE){
library("dplyr")
library("farff")
library("GGally")
library("keras")
library("tensorflow")
library("Metrics")
library("mlr")
library("OpenML")
library("reticulate")
library("rpart")
library("rpart.plot")
library("SPOT")
library("SPOTMisc")
library("tfdatasets")
library("rsample")
startMnistRun(timebudget=60, initSizeFactor = 1, verbosity = 1)
startMnistRun(timebudget=60, encoding="tensor", network="cnn")
}
}

}
