% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotTransform.R
\name{trans_10pow_round}
\alias{trans_10pow_round}
\title{10 power x transformation with round}
\usage{
trans_10pow_round(x)
}
\arguments{
\item{x}{input}
}
\value{
\code{round(10^x)}
}
\description{
Parameter values can be translated,
e.g., to base 10 as implemented in \code{\link{trans_10pow}}.
\code{trans_10pow_round} implements the transformation x -> round(2^x).
}
\examples{
f2 <- function(x){2^x}
fn <- c("identity", "exp", "f2")
xNat <- diag(3)
SPOT::transformX(xNat, fn)

}
