% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapParameters.R
\name{active2All}
\alias{active2All}
\title{Active to all}
\usage{
active2All(x, a, model)
}
\arguments{
\item{x}{subset of parameters}

\item{a}{names of the active parameters}

\item{model}{model (char)}
}
\value{
y full parameters
}
\description{
Recreates the full set of parameters from the subset of active ones.
}
\examples{
model <- "dl"
# indices of active variables
i <- c(1,3)
# names of active variables
a <- getVarNames(model=model,i=i)
x <- getModelConf(model=model)$defaults
# now matrix x has only active variables 1 and 3:
x <- x[1, getIndices(model=model, a=a), drop=FALSE]
# reconstruct the full set of parameters
active2All(x, a, model)
# 2nd example: new values to x (dropout=0.1, units=11):
x <- matrix(c(0.1,11), nrow=1)
a <- c("dropout", "units")
# reconstruct the full set of parameters
active2All(x, a, model)
# matrix
x <- rbind(x,2*x)
active2All(x, a, model)


}
