% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kerasHelper.R
\name{getKerasConf}
\alias{getKerasConf}
\title{Get keras configuration parameter list}
\usage{
getKerasConf()
}
\value{
kerasConf \code{list} with configuration parameters.
}
\description{
Configuration list for \code{keras}'s \code{\link[keras]{fit}} function.
}
\details{
Additional parameters passed to \code{keras}, e.g.,
\describe{
	\item{\code{verbose:}}{Verbosity mode (0 = silent, 1 = progress bar, 2 = one line per epoch). Default: \code{0}.}
	\item{\code{clearSession:}}{logical. Whether to call \code{\link[keras]{k_clear_session}} or not at the end of keras modelling. Default: \code{FALSE}.}
	\item{\code{resDummy:}}{logical. If \code{TRUE}, generate dummy (mock up) result for testing. If \code{FALSE}, run keras and tf evaluations.
	Default: \code{FALSE}.}
	\item{\code{naDummy:}}{numeric. Replacement for \code{NA} function values (loss/accuracy), e.g., \code{1234567890} if keras run is not
	successfully completed. This large dummy value can be used by optimizers that cannot handle \code{NAs}.}
	\item{\code{returnValue:}}{Return value. Can be one of \code{"trainingLoss"}, \code{"negTrainingAccuracy"},
	\code{"validationLoss"}, \code{"negValidationAccuracy"}, \code{"testLoss"}, or \code{"negTestAccuracy"}.
	Default: \code{"validationLoss"}.}
	\item{\code{callbacks:}}{List of callbacks to be called during training. Default: \code{list()}.}
	\item{\code{validation_split:}}{Float between 0 and 1. Fraction of the training data to be
         used as validation data. The model will set apart this fraction of the training data,
         will not train on it, and will evaluate the loss and any model metrics on this data at the end of each epoch.
         The validation data is selected from the last samples in the x and y data provided, before shuffling. Default: \code{0.2}.}
   \item{\code{validation_data (deprecated, see validationData):}}{Data on which to evaluate the loss and any model metrics at the end of each epoch.
    The model will not be trained on this data. This could be a list (x_val, y_val) or a list (x_val, y_val, val_sample_weights).
     validation_data will override validation_split. Default: \code{NULL}.}
   \item{\code{shuffle:}}{Logical (whether to shuffle the training data before each epoch) or string (for "batch").
   "batch" is a special option for dealing with the limitations of HDF5 data; it shuffles in batch-sized chunks.
   Has no effect when steps_per_epoch is not NULL. Default: \code{FALSE}.}
   \item{\code{trainData:}}{Train Data on which to evaluate the loss and any model metrics at the end of each epoch.}
   \item{\code{validationData:}}{Validation Data on which to evaluate the loss and any model metrics at the end of each epoch.}
   \item{\code{testData:}}{Test Data on which to evaluate the loss and any model metrics at the end of the optimization using evaluate().}
   }
}
\seealso{
\code{\link{evalKerasMnist}}

\code{\link{funKerasMnist}}

\code{\link[keras]{fit}}
}
