% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_refimg.R
\name{refImageBinaryKmeansMulti}
\alias{refImageBinaryKmeansMulti}
\title{Calculate the binary reference image using k-means clustering with multi-cluster
merging. K-means is run on the first `npcs` principal 
components to speed up the calculations.}
\usage{
refImageBinaryKmeansMulti(
  dataset,
  npcs = 10,
  mzQuery = numeric(),
  mzTolerance = Inf,
  useFullMZ = TRUE,
  numClusters = 4,
  kernelSize = 5,
  cores = 1,
  verbose = TRUE
)
}
\arguments{
\item{dataset}{\link{msi.dataset-class} object. See \link{msiDataset}.}

\item{npcs}{int (default = 10). Number of principal components to calculate.}

\item{mzQuery}{numeric. Values of m/z used to calculate the reference image.
2 values are interpreted as interval, multiple or single values are searched
in the m/z vector. It overrides the argument \code{useFullMZ}.}

\item{mzTolerance}{numeric (default = Inf). Tolerance in PPM to match the
\code{mzQueryRef} values in the m/z vector.}

\item{useFullMZ}{logical (default = TRUE). Whether all the peaks should be
used to calculate the reference image.}

\item{numClusters}{numeric (default = 4). Number of clusters.}

\item{kernelSize}{4-D numeric array or numeric (default = 5).
Each element of the 4-D array represents the size of the corners square kernels
used to determine the off-tissue clusters. The element order is clockwise:
top-left, top-right, bottom-left, bottom-right. If negative, the corresponding
corner is skipped. If only a single value is passed, the same kernel size is
used for the 4 corners.}

\item{cores}{numeric (default = 1). Number of CPU cores for parallel k-means.}

\item{verbose}{boolean (default = TRUE). Additional output.}
}
\value{
\link{ms.image-class} object with binary intensities.
}
\description{
Calculate the binary reference image using k-means clustering with multi-cluster
merging. K-means is run on the first `npcs` principal 
components to speed up the calculations.
}
