#' Deceleration of cars
#'
#' The deceleration of cars after adding additional speed signage.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 79 rows (one per car) and 2 columns:
#' \describe{
#'   \item{When}{When the deceleration is measured: \code{Before} or \code{After} signage added}
#'   \item{Deceleration}{The deceleration, in metres-per-second-squared}
#' }
#' @source 
#' Ma, Yongfeng, Wenbo Zhang, Xin Gu, and Jiguang Zhao. 2019.
#' Impacts of Experimental Advisory Exit Speed Sign on Traffic Speeds for Freeway Exit Ramp. 
#' \emph{PLoS One} \bold{14} (11): e0225203.
#' 
#' @usage 
#' data(Deceleration)
#' 
#' @examples
#' plot(Deceleration ~ factor(When), data = Deceleration)
#' 

"Deceleration"

