% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussIndependent.R
\name{GaussIndependent}
\alias{GaussIndependent}
\alias{GaussRank}
\title{Linearly independent rows and columns by Gaussian elimination}
\usage{
GaussIndependent(
  x,
  printInc = FALSE,
  tolGauss = (.Machine$double.eps)^(1/2),
  testMaxInt = 0,
  allNumeric = FALSE
)

GaussRank(x, printInc = FALSE)
}
\arguments{
\item{x}{A (sparse) matrix}

\item{printInc}{Printing "..." to console when \code{TRUE}}

\item{tolGauss}{A tolerance parameter for sparse Gaussian elimination and linear dependency. This parameter is used only in cases where integer calculation cannot be used.}

\item{testMaxInt}{Parameter for testing: The Integer overflow situation will be forced when testMaxInt is exceeded}

\item{allNumeric}{Parameter for testing: All calculations use numeric algorithm (as integer overflow) when TRUE}
}
\value{
List of logical vectors specifying independent rows and columns
}
\description{
The function is written primarily for large sparse matrices
}
\details{
GaussRank returns the rank
}
\examples{

x <- ModelMatrix(SSBtoolsData("z2"), formula = ~fylke + kostragr * hovedint - 1)

GaussIndependent(x)
GaussRank(x)
GaussRank(t(x))

\dontrun{
# For comparison, qr-based rank may not work
rankMatrix(x, method = "qr")

# Dense qr works 
qr(as.matrix(x))$rank
}
}
