% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapDiversity.R
\name{mapDiversity}
\alias{mapDiversity}
\alias{mapDiversity,Stacked.SDM-method}
\title{Map Diversity}
\usage{
mapDiversity(obj, ...)

\S4method{mapDiversity}{Stacked.SDM}(obj, method, rep.B = 1000, verbose = TRUE, Env = NULL, ...)
}
\arguments{
\item{obj}{Stacked.SDM. SSDM to map diversity with.}

\item{...}{other arguments pass to the method.}

\item{method}{character. Define the method used to create the local species
richness map (see details below).}

\item{rep.B}{integer. If the method used to create the local species richness
is the random Bernoulli (\strong{Bernoulli}), rep.B parameter defines the number of
repetitions used to create binary maps for each species.}

\item{verbose}{logical. If set to true, allows the function to print text in
the console.}

\item{Env}{raster object. Stacked raster object of environmental variables
(can be processed first by \code{\link{load_var}}). Needed only for stacking
method using probability ranking from richness (\strong{PRR}).}
}
\value{
a list with a diversity map and eventually ESDMs for stacking method
 using probability ranking from richness (\strong{PPR}).
}
\description{
Methods for Stacked.SDM or SSDM to map diversity and communities composition.
}
\details{
\strong{Methods:} Choice of the method used to compute the local
 species richness map (see Calabrese et al. (2014) and D'Amen et al (2015) for
 more informations, see reference below): \describe{\item{pSSDM}{sum
 probabilities of habitat suitability maps}\item{Bernoulli}{draw repeatedly
 from a Bernoulli distribution}\item{bSSDM}{sum the binary map obtained with
 the thresholding (depending on the metric of the
 ESDM).}\item{MaximumLikelihood}{adjust species richness of the model by
 linear regression}\item{PRR.MEM}{model richness with a macroecological model
 (MEM) and adjust each ESDM binary map by ranking habitat suitability and
 keeping as much as predicted richness of the MEM}\item{PRR.pSSDM}{model
 richness with a pSSDM and adjust each ESDM binary map by ranking habitat
 suitability and keeping as much as predicted richness of the pSSDM}}
}
\examples{

\dontrun{
# Loading data
data(Env)
data(Occurrences)
# SSDM building
SSDM <- stack_modelling(c('CTA', 'SVM'), Occurrences, Env, rep = 1,
                       Xcol = 'LONGITUDE', Ycol = 'LATITUDE',
                       Spcol = 'SPECIES')

# Diversity mapping
mapDiversity(SSDM, mathod = 'pSSDM')

}

}
\references{
M. D'Amen, A. Dubuis, R. F. Fernandes, J. Pottier, L. Pelissier, &
 A Guisan (2015) "Using species richness and functional traits prediction to
 constrain assemblage predicitions from stacked species distribution models"
 \emph{Journal of Biogeography} 42(7):1255-1266
 \url{http://doc.rero.ch/record/235561/files/pel_usr.pdf}

 J.M. Calabrese, G. Certain, C.  Kraan, & C.F. Dormann (2014) "Stacking
 species distribution  models  and  adjusting  bias  by linking them to
 macroecological models." \emph{Global Ecology and Biogeography} 23:99-112
 \url{https://onlinelibrary.wiley.com/doi/full/10.1111/geb.12102}
}
\seealso{
\code{\link{stacking}} to build SSDMs.
}
