% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Algorithm.SDM.R
\docType{class}
\name{Algorithm.SDM-class}
\alias{Algorithm.SDM-class}
\title{An S4 class to represent an SDM based on a single algorithm}
\description{
This is an S4 class to represent an SDM based on a single algorithm (including
generalized linear model, general additive model, multivariate adpative
splines, generalized boosted regression model, classification tree analysis,
random forest, maximum entropy, artificial neural network, and support vector
machines). This S4 class is obtained with \code{\link{modelling}}.
}
\section{Slots}{

\describe{
\item{\code{name}}{character. Name of the SDM (by default Species.SDM).}

\item{\code{projection}}{raster. Habitat suitability map produced by the SDM.}

\item{\code{binary}}{raster. Presence/Absence binary map produced by the SDM.}

\item{\code{evaluation}}{data frame. Evaluation of the SDM (available metrics include
AUC, Kappa, sensitivity, specificity and proportion of correctly predicted
occurrences) and identification of the optimal threshold to convert the
habitat suitability map into a binary presence/absence map.}

\item{\code{variable.importance}}{data frame. Relative importance of
each variable in the SDM.}

\item{\code{data}}{data frame. Data used to build the SDM.}

\item{\code{parameters}}{data frame. Parameters used to build the SDM.}
}}

\seealso{
\linkS4class{Ensemble.SDM} an S4 class for ensemble SDMs,
 and \linkS4class{Stacked.SDM} an S4 class for SSDMs.
}
