% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Democratic.R
\name{democraticG}
\alias{democraticG}
\title{Democratic generic method}
\usage{
democraticG(y, gen.learners, gen.preds)
}
\arguments{
\item{y}{A vector with the labels of training instances. In this vector the
unlabeled instances are specified with the value \code{NA}.}

\item{gen.learners}{A list of functions for training N different supervised base classifiers.
Each function needs two parameters, indexes and cls, where indexes indicates
the instances to use and cls specifies the classes of those instances.}

\item{gen.preds}{A list of functions for predicting the probabilities per classes.
Each function must be two parameters, model and indexes, where the model
is a classifier trained with \code{gen.learner} function and
indexes indicates the instances to predict.}
}
\value{
A list object of class "democraticG" containing:
\describe{
\item{W}{A vector with the confidence-weighted vote assigned to each classifier.}
\item{model}{A list with the final N base classifiers trained using the
enlarged labeled set.}
\item{model.index}{List of N vectors of indexes related to the training instances
used per each classifier. These indexes are relative to the \code{y} argument.}
\item{instances.index}{The indexes of all training instances used to
train the N \code{models}. These indexes include the initial labeled instances
and the newly labeled instances. These indexes are relative to the \code{y} argument.}
\item{model.index.map}{List of three vectors with the same information in \code{model.index}
but the indexes are relative to \code{instances.index} vector.}
\item{classes}{The levels of \code{y} factor.}
}
}
\description{
Democratic is a semi-supervised learning algorithm with a co-training
style. This algorithm trains N classifiers with different learning schemes defined in
list \code{gen.learners}. During the iterative process, the multiple classifiers with
different inductive biases label data for each other.
}
\details{
democraticG can be helpful in those cases where the method selected as
base classifier needs a \code{learner} and \code{pred} functions with other
specifications. For more information about the general democratic method,
please see \code{\link{democratic}} function. Essentially, \code{democratic}
function is a wrapper of \code{democraticG} function.
}
\references{
Yan Zhou and Sally Goldman.\cr
\emph{Democratic co-learning.}\cr
In IEEE 16th International Conference on Tools with Artificial Intelligence (ICTAI),
pages 594-602. IEEE, Nov 2004. doi: 10.1109/ICTAI.2004.48.
}
