% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunction.R
\name{STSIdentifyCandidateSTMotifs}
\alias{STSIdentifyCandidateSTMotifs}
\title{Generate candidates}
\usage{
STSIdentifyCandidateSTMotifs(data, tslice, sslice, alpha = 7,
  window_size = 3)
}
\arguments{
\item{data}{Dataset containing numeric values}

\item{tslice}{"Time slice" Number of rows in each block}

\item{sslice}{"Space slice" Number of columns in each block}

\item{alpha}{Number of letters to do the encode}

\item{window_size}{Length of motifs}
}
\value{
List [Motifs, Nrows, Ncols, Rectangles, Blocks, Saxblocks] containing all information about the blocks: number of blocks in horizontal and vertical, values of each block (numeric and SAX encoded) and information about frequent candidates in blocks

Motifs: Contain for each block the Subs: dataframe containing all the subsequences in the original dataframe; Subs.SAX: a dataframe containing all the subsequences in SAX representations; Motif.raw: a list showing the candidates discovered in the original dataframe; Motif.SAX: a list showing the candidates discovered in SAX representations and Indices: a list showing the starting positions of subsequences for each candidate discovered.

Nrows and Ncols: Number of blocks in horizontal and vertical

Rectangles: For each block gives information about the position of the block into the original dataset

Blocks: Contains the values of each block

Saxblocks: Contains the values encoded by SAX of each block
}
\description{
Find frequent candidates in a dataset
}
\note{
To see all the stages of the generation of candidates: \href{../inst/doc/generation-of-candidates.html}{Generation of candidates}
}
\examples{
#Generation of candidates
candidates <- STSIdentifyCandidateSTMotifs(STMotif::example_dataset, 10, 10, 7, 3)
}
