% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stutter_functions.R
\name{findStutter}
\alias{findStutter}
\title{Find stutters}
\usage{
findStutter(stringCoverageGenotypeListObject, trace = FALSE)
}
\arguments{
\item{stringCoverageGenotypeListObject}{A \link{stringCoverageGenotypeList-class} object.}

\item{trace}{Should a trace be shown?}
}
\value{
A 'neighbourList' with the stutter strings for the identified allele regions.
}
\description{
Given identified alleles it search for '-1' stutters of the alleles.
}
\examples{
# The object returned by merging a stringCoverageList-Object
# and a genotypeList-Object.
data("stringCoverageGenotypeList")

stutterList <- findStutter(stringCoverageGenotypeList)
stutterTibble <- subset(do.call("rbind", stutterList), !is.na(Genotype))

stutterTibble$BlockLengthMissingMotif
stutterTibble$NeighbourRatio
}
