% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_genotype_functions.R
\name{getGenotype}
\alias{getGenotype}
\title{Assigns genotype.}
\usage{
getGenotype(
  stringCoverageListObject,
  colBelief = "Coverage",
  thresholdSignal = 0,
  thresholdHeterozygosity = 0.35,
  thresholdAbsoluteLowerLimit = 1
)
}
\arguments{
\item{stringCoverageListObject}{an stringCoverageList-object, created using the \link{stringCoverage}-function.}

\item{colBelief}{the name of the coloumn used for identification.}

\item{thresholdSignal}{threshold applied to the signal (generally the coverage) of every string.}

\item{thresholdHeterozygosity}{threshold used to determine whether a marker is hetero- or homozygous.}

\item{thresholdAbsoluteLowerLimit}{a lower limit on the coverage for it to be called as an allele.}
}
\value{
Returns a list, with an element for every marker in stringCoverageList-object, each element contains the genotype for a given marker.
}
\description{
\code{getGenotype} takes an stringCoverageList-object, assumes the sample is a reference file and assings a genotype, based on a heterozygote threshold, for every marker in the provided list.
}
\examples{
# Strings aggregated by 'stringCoverage()'
data("stringCoverageList")

getGenotype(stringCoverageList)
}
