% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STR_Region_Identification.R
\name{identifySTRRegions,ShortReadQ-method}
\alias{identifySTRRegions,ShortReadQ-method}
\title{Identify the STR regions of a fastq-file or ShortReadQ-object.}
\usage{
\S4method{identifySTRRegions}{ShortReadQ}(
  reads,
  flankingRegions,
  numberOfMutation = 1,
  control = identifySTRRegions.control()
)
}
\arguments{
\item{reads}{a ShortReadQ-object}

\item{flankingRegions}{containing marker ID/name, the directly adjacent forward and reverse flanking regions, used for identification.}

\item{numberOfMutation}{the maximum number of mutations (base-calling errors) allowed during flanking region identification.}

\item{control}{an \link{identifySTRRegions.control}-object.}
}
\value{
The returned object is a list of lists. If the reverse complement strings are not included or if the \code{control$combineLists == TRUE},
a list, contains lists of untrimmed and trimmed strings for each row in \code{flankingRegions}. If \code{control$combineLists == FALSE}, the function returns a list of two such lists,
one for forward strings and one for the reverse complement strings.
}
\description{
\code{identifySTRRegions} takes a fastq-file location or a ShortReadQ-object and identifies the STR regions
based on a directly adjacent flanking regions.
The function allows for mutation in the flanking regions through the numberOfMutation argument.
}
