% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_weights.R
\name{plot_weights}
\alias{plot_weights}
\title{Visualizing the loading of the features}
\usage{
plot_weights(
  sim_object = NULL,
  factor_num = 1,
  data = "omic.one",
  type = "scatter"
)
}
\arguments{
\item{sim_object}{R object containing data to be plotted}

\item{factor_num}{Factor to be plotted.}

\item{data}{Section of the integrated data to be plotted, omic.one or omic.two are the options}

\item{type}{Type of plot. Scatter plot and histogram are the only allowed plots}
}
\value{
A ggplot object.
If \code{type} is "scatter", the function returns a scatter plot visualizing the loadings of features for the selected factor.
If \code{type} is "histogram", the function returns a histogram displaying the distribution of the loadings for the selected factor.
The plot visualizes either \code{omic.one} or \code{omic.two} data based on the user input in the \code{data} parameter.
The ggplot object can be further modified or directly plotted.
}
\description{
Visualizing the loading of the features
}
\examples{
# Examples
output_obj <- OmixCraftHD(
  vector_features = c(2000,3000),
  sigmas_vector=c(8,5),
  n_samples=100,
  n_factors=4,
  num.factor='multiple',
  advanced_dist='mixed'
)
plot_weights(sim_object = output_obj, factor_num = 1, data = 'omic.one', type = 'scatter')
plot_weights(sim_object = output_obj, factor_num = 1, data = 'omic.one', type = 'histogram')
plot_weights(sim_object = output_obj, factor_num = 1, data = 'omic.two', type = 'scatter')
plot_weights(sim_object = output_obj, factor_num = 1, data = 'omic.two', type = 'histogram')
}
