/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.mozilla.javascript.ClassOutput;
import org.mozilla.javascript.ClassRepository;
import org.mozilla.javascript.Context;

public abstract class ClassNameHelper {
    private static ClassNameHelper savedNameHelper;
    private static boolean helperNotAvailable;

    public static ClassNameHelper get(Context cx) {
        ClassNameHelper helper = savedNameHelper;
        if (helper == null && !helperNotAvailable) {
            try {
                Class<?> nameHelperClass = Class.forName("org.mozilla.javascript.optimizer.OptClassNameHelper");
                helper = (ClassNameHelper)nameHelperClass.newInstance();
            }
            catch (ClassNotFoundException x) {
            }
            catch (IllegalAccessException x) {
            }
            catch (InstantiationException x) {
                // empty catch block
            }
            if (helper != null) {
                savedNameHelper = helper;
            } else {
                helperNotAvailable = true;
            }
        }
        return helper;
    }

    static void clearCache() {
        ClassNameHelper helper = savedNameHelper;
        if (helper != null) {
            helper.reset();
        }
    }

    public String getTargetClassFileName() {
        ClassRepository repository = this.getClassRepository();
        if (repository instanceof FileClassRepository) {
            return ((FileClassRepository)repository).getTargetClassFileName(this.getClassName());
        }
        return null;
    }

    public void setTargetClassFileName(String classFileName) {
        if (classFileName != null) {
            this.setClassRepository(new FileClassRepository(classFileName));
        } else {
            this.setClassName(null);
        }
    }

    public final ClassOutput getClassOutput() {
        ClassRepository repository = this.getClassRepository();
        if (repository instanceof ClassOutputWrapper) {
            return ((ClassOutputWrapper)repository).classOutput;
        }
        return null;
    }

    public void setClassOutput(ClassOutput classOutput) {
        if (classOutput != null) {
            this.setClassRepository(new ClassOutputWrapper(classOutput));
        } else {
            this.setClassRepository(null);
        }
    }

    public abstract String getTargetPackage();

    public abstract void setTargetPackage(String var1);

    public abstract void setTargetExtends(Class var1);

    public abstract void setTargetImplements(Class[] var1);

    public abstract ClassRepository getClassRepository();

    public abstract void setClassRepository(ClassRepository var1);

    public abstract String getClassName();

    public abstract void setClassName(String var1);

    public abstract void reset();

    private static class ClassOutputWrapper
    implements ClassRepository {
        ClassOutput classOutput;

        ClassOutputWrapper(ClassOutput classOutput) {
            this.classOutput = classOutput;
        }

        public boolean storeClass(String name, byte[] bytes, boolean tl) throws IOException {
            OutputStream out = this.classOutput.getOutputStream(name, tl);
            out.write(bytes);
            out.close();
            return true;
        }
    }

    private class FileClassRepository
    implements ClassRepository {
        String generatingDirectory;

        FileClassRepository(String classFileName) {
            String initialName;
            int lastSeparator = classFileName.lastIndexOf(File.separatorChar);
            if (lastSeparator == -1) {
                this.generatingDirectory = null;
                initialName = classFileName;
            } else {
                this.generatingDirectory = classFileName.substring(0, lastSeparator);
                initialName = classFileName.substring(lastSeparator + 1);
            }
            if (initialName.endsWith(".class")) {
                initialName = initialName.substring(0, initialName.length() - 6);
            }
            ClassNameHelper.this.setClassName(initialName);
        }

        public boolean storeClass(String className, byte[] bytes, boolean tl) throws IOException {
            String targetPackage = ClassNameHelper.this.getTargetPackage();
            if (targetPackage != null && targetPackage.length() > 0 && className.startsWith(targetPackage + ".")) {
                className = className.substring(targetPackage.length() + 1);
            }
            FileOutputStream out = new FileOutputStream(this.getTargetClassFileName(className));
            out.write(bytes);
            out.close();
            return false;
        }

        String getTargetClassFileName(String className) {
            StringBuffer sb = new StringBuffer();
            if (this.generatingDirectory != null) {
                sb.append(this.generatingDirectory);
                sb.append(File.separator);
            }
            sb.append(className);
            sb.append(".class");
            return sb.toString();
        }
    }
}

