/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;

public class StmtNodeIterator {
    private ObjArray itsStack = new ObjArray();
    private Node itsStart;
    private Node itsCurrentNode;

    public StmtNodeIterator(Node start) {
        this.itsStart = start;
    }

    private Node findFirstInterestingNode(Node theNode) {
        while (theNode != null) {
            int type = theNode.getType();
            if (type != 133 && type != 138 && type != 110) break;
            Node first = theNode.getFirstChild();
            if (first == null) {
                theNode = theNode.getNext();
                continue;
            }
            this.itsStack.push(theNode);
            theNode = first;
        }
        return theNode;
    }

    public Node nextNode() {
        if (this.itsCurrentNode == null) {
            this.itsCurrentNode = this.findFirstInterestingNode(this.itsStart);
            return this.itsCurrentNode;
        }
        this.itsCurrentNode = this.itsCurrentNode.getNext();
        if (this.itsCurrentNode == null) {
            while (!this.itsStack.isEmpty()) {
                Node n = (Node)this.itsStack.pop();
                Node next = n.getNext();
                if (next == null) continue;
                this.itsCurrentNode = this.findFirstInterestingNode(next);
                return this.itsCurrentNode;
            }
            return null;
        }
        this.itsCurrentNode = this.findFirstInterestingNode(this.itsCurrentNode);
        return this.itsCurrentNode;
    }
}

