% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ispline.R
\name{isb}
\alias{isb}
\title{I-spline basis of each column of a given matrix}
\usage{
isb(x, spline.knots = 0, knots = NULL, spline.degree = 1)
}
\arguments{
\item{x}{The predictor variable, which will be transformed into I-spline
basis.}

\item{spline.knots}{Number of inner knots to use. \code{isb} will equally
distribute the knots over the value range using quantiles.
\code{spline.knots} will only be used if \code{knots} is not given.}

\item{knots}{An array consisting all knots (boundary knots as well as the
interior knots) to be used to create the spline basis.}

\item{spline.degree}{The polynomial degree of the spline basis.}
}
\value{
The I-spline with the used spline settings as attribute. The
spline settings attribute can transform the same attribute of any other
objects using the same knots.
}
\description{
Create a I-spline basis for an array. \code{isb} will equally distribute the 
knots over the value range using quantiles.
}
\examples{
## plot the spline transformation given a monotone sequence
B0 <- isb(0:100, spline.knots = 2, spline.degree = 3)
plot(NULL, xlim = c(0, 140), ylim = c(0, 1), xlab = 'x',ylab = 'I-spline')
for(i in 1:ncol(B0))
  lines(B0[,i], col = i, lwd = 3)
legend('bottomright', legend = 1:ncol(B0), col = 1:ncol(B0),
  lty = 1, lwd = 3, title = 'Spline Columns'
)
## create I-spline basis for the first 50 observations
x  <- iris$Sepal.Length
B1  <- isb(x[1:50], spline.knots = 4, spline.degree = 3)
## extracting the spline transformation settings
spline.param <- attr(B1, 'splineInterval')
## use the same settings to apply to the next 50 observations
B2 <- isb(x[-(1:50)], spline.degree = 3, knots = spline.param)
}
\references{
P.J.F. Groenen, G. Nalbantov and J.C. Bioch (2008) 
\emph{SVM-Maj: a majorization approach to linear support vector machines with
different hinge errors.} 

J.O. Ramsay (1988) \emph{Monotone regression
splines in action.} Statistical Science, 3(4):425-461
}
\seealso{
\code{\link[SVMMaj]{svmmaj}}
}
\author{
Hok San Yip, Patrick J.F. Groenen, Georgi Nalbantov
}
