% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/swmpr_analyze.R
\name{aggremetab}
\alias{aggremetab}
\alias{aggremetab.swmpr}
\title{Aggregate metabolism data}
\usage{
aggremetab(swmpr_in, ...)

\method{aggremetab}{swmpr}(swmpr_in, by = "weeks", na.action = na.pass,
  alpha = 0.05, ...)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{additional arguments passed to other methods}

\item{by}{chr string of time period for aggregation one of \code{'years'}, \code{'quarters'}, \code{'months'}, \code{'weeks'}, \code{'days'}, or \code{'hours'}}

\item{na.action}{function for treating missing data, default \code{na.pass}}

\item{alpha}{numeric indicating alpha level of confidence interval for aggregated data}
}
\value{
Returns an aggregated metabolism \code{\link[base]{data.frame}} if the \code{metabolism} attribute of the swmpr object is not \code{NULL}.
}
\description{
Aggregate a metabolism attribute from swmpr data by a specified time period and method
}
\details{
The function summarizes metabolism data by averaging across set periods of observation. Confidence intervals are also returned based on the specified alpha level.  It is used within \code{\link{plot_metab}} function to view summarized metabolism results.  Data can be aggregated by \code{'years'}, \code{'quarters'}, \code{'months'}, or \code{'weeks'} for the supplied function, which defaults to the \code{\link[base]{mean}}. The method of treating NA values for the user-supplied function should be noted since this may greatly affect the quantity of data that are returned.
}
\examples{
\dontrun{
## import water quality and weather data
data(apadbwq)
data(apaebmet)

## qaqc, combine
wq <- qaqc(apadbwq)
met <- qaqc(apaebmet)
dat <- comb(wq, met)

## estimate metabolism
res <- ecometab(dat)

## change aggregation period and alpha
aggremetab(res, by = 'months', alpha = 0.1)
}
}
\seealso{
\code{\link[stats]{aggregate}}, \code{\link{aggreswmp}}, \code{\link{ecometab}}, \code{\link{plot_metab}}
}
\concept{
analyze
}

