% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/swmpr_analyze.R
\name{map_reserve}
\alias{map_reserve}
\title{Map a reserve}
\usage{
map_reserve(nerr_site_id, zoom = 11, text_sz = 6, text_col = "black",
  map_type = "terrain")
}
\arguments{
\item{nerr_site_id}{chr string of the reserve to map, first three characters used by NERRS or vector of stations to map using the first five characters}

\item{zoom}{numeric value for map zoom, passed to \code{\link[ggmap]{get_map}}}

\item{text_sz}{numeric value for text size of station names, passed to \code{\link[ggplot2]{geom_text}}}

\item{text_col}{chr string for text color of station names, passed to \code{\link[ggplot2]{geom_text}}}

\item{map_type}{chr string indicating the type of base map obtained from Google maps, values are \code{terrain} (default), \code{satellite}, \code{roadmap}, or \code{hybrid}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object for plotting.
}
\description{
Create a map of all the stations in a reserve
}
\details{
This function is a simple wrapper to functions in the ggmap package which returns a map of all of the stations at a NERRS reserve.  The \code{zoom} argument may have to be chosen through trial and error depending on the spatial extent of the reserve.  A local data file included with the package is used to get the latitude and longitude values of each station.  The files includes only active stations as of January 2015.
}
\examples{
## defaults

map_reserve('jac')

## change defaults, map a single site

map_reserve('gtmss', zoom = 15, map_type = 'satellite',
 text_col = 'lightblue')
}
\seealso{
\code{\link[ggmap]{get_map}}, \code{\link[ggmap]{ggmap}}, \code{\link[ggplot2]{ggplot}}
}
\concept{
analyze
}

