% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_results_table.R
\name{generate_results_table}
\alias{generate_results_table}
\title{Filter Reformatted Seasonal Kendall Results}
\usage{
generate_results_table(sk_result, stations, param)
}
\arguments{
\item{sk_result}{a \code{data.frame} of reformatted seasonal kendall results from \code{\link{sk_seasonal}}.}

\item{stations}{chr, vector of station names included in \code{sk_result} that will be displayed in the NERRS reserve level report}

\item{param}{chr, vector of parameters included in \code{sk_result} that will be displayed in the NERRS reserve level report}
}
\value{
Returns a \code{data.frame} of user-specified results to be displayed
}
\description{
Filters a \code{dataframe} of user-specified results for display in the NERRS reserve level report
}
\details{
A helper function used internally by \code{\link{create_sk_flextable_list}} to create a \code{data.frame} of user specified parameters to be displayed in the reserve level report.
}
\author{
Julie Padilla
}
\concept{
reporting
}
