% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonal_boxplot.R
\name{seasonal_boxplot}
\alias{seasonal_boxplot}
\alias{seasonal_boxplot.swmpr}
\title{Seasonal boxplots}
\usage{
seasonal_boxplot(swmpr_in, ...)

\method{seasonal_boxplot}{swmpr}(
  swmpr_in,
  param = NULL,
  hist_rng = NULL,
  target_yr = NULL,
  criteria = NULL,
  free_y = FALSE,
  log_trans = FALSE,
  converted = FALSE,
  criteria_lab = "WQ Threshold",
  stat_lab = "Average",
  plot_title = FALSE,
  plot = TRUE,
  FUN = function(x) mean(x, na.rm = TRUE),
  ...
)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{additional arguments passed to other methods. See \code{\link{assign_season}}}

\item{param}{chr string of variable to plot}

\item{hist_rng}{numeric vector, if historic range is not specified then the min/max values of the data set will be used.}

\item{target_yr}{numeric, the target year that should be compared against the historic range. If target year is not specified then dot will not be plotted}

\item{criteria}{numeric, a numeric criteria that will be plotted as a horizontal line}

\item{free_y}{logical, should the y-axis be free? Defaults to \code{FALSE}. If \code{FALSE}, defaults to zero, unless negative values are present. If \code{TRUE}, y-axis limits are selected by \code{ggplot}}

\item{log_trans}{logical, should y-axis be log? Defaults to \code{FALSE}}

\item{converted}{logical, were the units converted from the original units used by CDMO? Defaults to \code{FALSE}. See \code{y_labeler} for details.}

\item{criteria_lab}{chr, label for the threshold criteria defined in \code{criteria}. Defaults to "WQ Threshold"}

\item{stat_lab}{chr, label for the summary statistic defined in \code{FUN}. Defaults to "Average"}

\item{plot_title}{logical, should the station name be included as the plot title? Defaults to \code{FALSE}}

\item{plot}{logical, should a plot be returned? Defaults to \code{TRUE}}

\item{FUN}{function used to aggregate daily SWMP data}
}
\value{
Returns a \code{\link[ggplot2]{ggplot}} object or a \code{data.frame} if \code{plot = FALSE}
}
\description{
Annual time series for year of interest on top of long-term percentiles
}
\details{
This function uses boxplots to summarize statistics calculated on a daily basis across user-defined seasons for all years within the historic range (\code{hist_rng}). If \code{hist_rng} is not specified then the minimum and maximum years within the data set will be used. The summary statistics used to generate the boxplots are \code{ggplot2} defaults: the center of the box is a median, and the lower/upper limits of the box are the 25-th and 75-th percentiles. The whiskers extend to the furthest data point within 1.5 * inter-quartile range (IQR). The dots beyond the whiskers are data points that are greater than 1.5 * IQR. If the user selects a \code{target_yr}, then a median summary statistic value will be plotted as a point against the boxplots.

Using the \code{FUN} argument, the user can specify the daily summary statistic to use. Commonly used statistics are \code{min(x, na.rm = TRUE)}, \code{mean(x, na.rm = TRUE)}, and \code{max(x, na.rm = TRUE)}. After specifying \code{FUN}, the user should also specify \code{stat_lab}, which is used to construct appropriate legend labels.

The user also has the option to add a threshold hold line using the \code{criteria} argument. Typically, this value is a water quality threshold, which is why \code{criteria_lab} defaults to \code{'WQ Threshold'}. Howver, the user has the option to specify any other type of threshold they wish. when doing so, the value for \code{criteria_lab} should be changed accordingly.
}
\examples{
\dontshow{
data(apacpwq)

dat <- qaqc(apacpwq, qaqc_keep = c('0', '3', '5'))

y <- seasonal_boxplot(dat, param = 'do_mgl', target_yr = 2012)
}

\donttest{
dat <- elksmwq
dat <- qaqc(dat, qaqc_keep = c('0', '3', '5'))

x <-
  seasonal_boxplot(dat, param = 'do_mgl')

y <-
    seasonal_boxplot(dat, param = 'do_mgl', target_yr = 2015,
    season_grps = list(c(1,2,3), c(4,5,6), c(7,8,9), c(10, 11, 12)),
    season_names = c('Winter', 'Spring', 'Summer', 'Fall'),
    season_start = 'Spring')

z_min <-
   seasonal_boxplot(dat, param = 'do_mgl',
   stat_lab = 'Minimum', FUN = function(x) min(x, na.rm = TRUE))

z_max <-
   seasonal_boxplot(dat, param = 'do_mgl',
   stat_lab = 'Maximum', FUN = function(x) max(x, na.rm = TRUE))
}
}
\seealso{
\code{\link[ggplot2]{ggplot}}, \code{\link{assign_season}}
}
\author{
Julie Padilla
}
\concept{analyze}
