% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geographic_unique_stations.R
\name{geographic_unique_stations}
\alias{geographic_unique_stations}
\title{Return a vector of geographically unique NERR Stations}
\usage{
geographic_unique_stations(nerr_site_id)
}
\arguments{
\item{nerr_site_id}{chr vector of valid NERR stations}
}
\value{
returns a vector of NERR stations
}
\description{
Creates an alphabetically sorted, vector of geographically unique stations for mapping
}
\details{
This function is intended for internal use with the NERRS reserve level reporting scripts and is used along with \code{\link{res_local_map}}. It takes a vector of NERR site ids and only returns geographically unique locations.
}
\examples{
stns <- c('apacpnut', 'apacpwq', 'apadbnut', 'apadbwq', 'apaebmet',
'apaebnut', 'apaebwq', 'apaesnut', 'apaeswq')

geographic_unique_stations(stns)

}
\author{
Julie Padilla
}
\concept{mapping}
